import javax.media.j3d.*;
import javax.vecmath.*; 
import java.awt.*;
import java.awt.event.*;
import com.sun.j3d.utils.geometry.*;
/**
 * This application uses a switch node to swap between two shapes.
 * The switch is driven by two AWT buttons.
 * @author I.J.Palmer
 * @version 1.0
 */
public class SimpleSwitch extends Frame implements ActionListener {
	protected Canvas3D myCanvas3D = new Canvas3D(null);
	/** The exit button */
	protected Button exitButton = new Button("Exit");
	/** Set the shape to a box */
	protected Button boxButton = new Button("Box");
	/** Set the shape to a cone */
	protected Button coneButton = new Button("Cone");
	/** The switch that is used to swap between the shapes */
	protected Switch firstSwitch = new Switch(0);
    /**
     * This function builds the view branch of the scene
     * graph.  It creates a branch group and then creates the
     * necessary view elements to give a useful view of our
     * content.
     * @param c Canvas3D that will display the view
     * @return BranchGroup that is the root of the view elements
     */
	protected BranchGroup buildViewBranch(Canvas3D c) {
		BranchGroup viewBranch = new BranchGroup();
		Transform3D viewXfm = new Transform3D();
            viewXfm.set(new Vector3f(0.0f,0.0f,10.0f));
		TransformGroup viewXfmGroup = new TransformGroup(viewXfm);
		ViewPlatform myViewPlatform = new ViewPlatform();
            PhysicalBody myBody = new PhysicalBody();
            PhysicalEnvironment myEnvironment = new PhysicalEnvironment();
		viewXfmGroup.addChild(myViewPlatform);
		viewBranch.addChild(viewXfmGroup);
		View myView = new View();
		myView.addCanvas3D(c);
		myView.attachViewPlatform(myViewPlatform);
            myView.setPhysicalBody(myBody);
            myView.setPhysicalEnvironment(myEnvironment);
		return viewBranch;
	}
    /**
     * Add some lights so that we can illuminate the scene.
     * This adds one ambient light to bring up the overall 
     * lighting level and one directional shape to show
     * the shape of the objects in the scene.
     * @param b BranchGroup that the lights are to be added to.
     */
      protected void addLights(BranchGroup b) {
            BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
            Color3f lightColour1 = new Color3f(1.0f, 1.0f, 1.0f);
            Vector3f lightDir1  = new Vector3f(0.0f, -1.0f, 0.0f);
            Color3f lightColour2 = new Color3f(1.0f, 1.0f, 1.0f);
            Vector3f lightDir2  = new Vector3f(0.0f, 1.0f, 0.0f);
            DirectionalLight light1 = new DirectionalLight(lightColour1, lightDir1);
            light1.setInfluencingBounds(bounds);
            DirectionalLight light2 = new DirectionalLight(lightColour2, lightDir2);
            light2.setInfluencingBounds(bounds);
            b.addChild(light1);
            b.addChild(light2);
      }
    /**
     * This builds the content branch of our scene graph.
     * The root of the shapes supplied as a parameter
     * is slightly tilted to reveal its 3D shape. It also uses
     * the addLights function to add some lights to the scene.
     * @param shape Node that represents the geometry for the content
     * @return BranchGroup that is the root of the content branch
     */
      protected BranchGroup buildContentBranch(Node shape) {
		BranchGroup contentBranch = new BranchGroup();
		Transform3D rotateCube = new Transform3D( );
            rotateCube.set(new AxisAngle4d(1.0,1.0,0.0,Math.PI/4.0));
		TransformGroup rotationGroup = new TransformGroup(rotateCube);
		contentBranch.addChild(rotationGroup);
            rotationGroup.addChild(shape);
            addLights(contentBranch);
	    return contentBranch;
      } 
    /**
     * This creates the shapes used in the program.
     * A switch node is created that has its write capability set so that 
     * we can swap the rendered shape.  Then a box and a cone are
     * created and added to the switch.
     * @return Node that is the switch node
     */     
	protected Node buildShape() {
		Appearance app = new Appearance();
            	Color3f ambientColour = new Color3f(1.0f,0.0f,0.0f);
            	Color3f emissiveColour = new Color3f(0.0f,0.0f,0.0f);
		Color3f specularColour = new Color3f(1.0f,1.0f,1.0f);
            	Color3f diffuseColour = new Color3f(1.0f,0.0f,0.0f);
            	float shininess = 20.0f;
            	app.setMaterial(new Material(ambientColour,emissiveColour,
            			diffuseColour,specularColour,shininess));
            //Set the capability so that we can change the switch value
		firstSwitch.setCapability(Switch.ALLOW_SWITCH_WRITE);
		//Add the two shapes to the switch
		firstSwitch.addChild(new Box(2.0f,2.0f,2.0f,Box.GENERATE_NORMALS,app));
		firstSwitch.addChild(new Cone(2.0f,4.0f,Cone.GENERATE_NORMALS,app));
		return firstSwitch;
	}
    /**
     * Process the AWT events and perform the appropriate actions.
     * If the exit button has been pressed, quit the application, 
     * if the box button has been pressed, select the box child
     * of the switch and if its the cone button select the cone
     * child.
     * @param e ActionEvent that is to be processed.
     */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == exitButton) {
			dispose();
        	        System.exit(0);
		} else if (e.getSource() == boxButton) {
			firstSwitch.setWhichChild(0);
		} else if (e.getSource() == coneButton) {
			firstSwitch.setWhichChild(1);
		}
	}
        public SimpleSwitch() {
		VirtualUniverse myUniverse = new VirtualUniverse();
		Locale myLocale = new Locale(myUniverse);
                myLocale.addBranchGraph(buildViewBranch(myCanvas3D));
                myLocale.addBranchGraph(buildContentBranch(buildShape()));
		setTitle("SimpleWorld");
		setSize(400,400);
		setLayout(new BorderLayout());
		Panel bottom = new Panel();
		bottom.add(boxButton);
		bottom.add(coneButton);
		bottom.add(exitButton);
		add(BorderLayout.CENTER,myCanvas3D);
		add(BorderLayout.SOUTH,bottom);
                exitButton.addActionListener(this);
               	boxButton.addActionListener(this);
               	coneButton.addActionListener(this);
                setVisible(true);
	}
	public static void main(String[] args) {
                  SimpleSwitch ss = new SimpleSwitch();
	}
}
